/*******************************************************************************************
* ChristmasTree
* Build on knowledge of nested loops to create a colorful tree to the user�s
* specifications
*
* // 1) Use nested loops to create:
* 1
* 22
* 333
* etc.
* // 2) Ask the user how tall they want a Christmas tree. nested loop to create:
* 1
* 2 2
* 3 3 3
* 4 4 4 4
* 5 5 5 5 5
* 6 6 6 6 6 6
* etc.
* // 3) Add a stump to the tree
* // 4) Add color to the text (random Christmas ornaments would be nice)
* // 5) Improve the program beyond requirements
*
* Author: Abigail Mott
* Date: 10/24/2024
* Time Spent: like 30 minutes
*******************************************************************************************/
using namespace std;
#include <iostream>

//random number stuff v
#include <cstdlib>  
#include <ctime>  

int userTall;

int acceptUserInfo() {
	//ask user for how tall they want chrima tree
	cout << "Heyy, how tall you want your christmas tree to be?";
	bool validInput = true;
	do {
		cin >> userTall;
		if (cin.fail() || userTall <= 0) {
			validInput = false;
			cout << "Please give an integer for chrima tree thats bigger than 0. \n";
			cin.clear();
			cin.ignore(numeric_limits<streamsize>::max(), '\n');
		}
		else {
			validInput = true;
		}
	} while (!validInput);
	return userTall;
}

void makeChristmasTree() {
	//how tall chrima tree is
	int count = acceptUserInfo();
	for (int i = 0; i <= count; i++) {
		//starts new line for chrima tree
		cout << "\n";
		for (int j = 0; j <= count; j++) {
			//prints out the spacing
			cout << " ";
		}
		for (int k = 0; k < count; k++) {
			if (count == 1) {
				cout << "* ";
			}
			if (count != 1) {
				int max = 4;
				int min = 1;

				// Seed the random number generator  
				std::srand(static_cast<unsigned int>(std::time(0)));
				int randomNum = min + (std::rand() % ((max - min) + 1));
				if (randomNum == 4) {
					cout << "o ";
				}
				if (randomNum == 3) {
					cout << "o ";
				}
				if (randomNum <= 2) {
					cout << "^ ";
				}
			}
		}
	}
	cout << "\n";
	for (int d = 1; d <= count; d++) {
		cout << " ";
	}
	count++;
	cout << "]|[";
}

int main() {
	cout << "Make chrima tree\n";
	makeChristmasTree();
}