// import the Scanner library
import java.util.Scanner;
/*******************************************************************************************
*    CoinFlip
*        If a user flips a fair coin, what are the chances the coin will land on heads?
*        What if the user flips the coin again? What are the odds that the coin will
*        land on heads twice in a row? Three times in a row?
*        This program will print out the probability of a coin landing on heads a
*        user-specified number of times in a row. The program  also introduces
*        the concept to the user
*
*    Author: Abigail Mott
*    Date: 10/30/2023 - updated 10/7/2025
*    Time Spent: 45 minutes
*******************************************************************************************/
public class CoinFlip{
    /*******************************************************************************************
    *    main()
    *        This is the entry point of the program. For this basic program, it receives
    *        input, and prints “Hello World ” on the console a user-specified number of
    *        times.
    *******************************************************************************************/
    public static void main(String[] args){
              //calls on the program to then run through the 3 functions in order
              neverTellMeTheOdds(calculateOdds(getNumberOfFlips()));
     }

    /*******************************************************************************************
    *    getNumberOfFlips()
    *   This function gets the user input on how many times it flips
    ******************************************************************************************/
    public static int getNumberOfFlips(){
        //scanner
        Scanner input = new Scanner(System.in); 
        //how many times flip time?
        System.out.println("Give me a number on how many times you fliped a coin.");
        //Secured the user input
        int userFlip = input.nextInt();
        //won't accept user input again
        input.close();
        return userFlip;
    }

    /*******************************************************************************************
    *   calculateOdds()
    *       This function takes the user input from getNumberOfFlips() and calculates the odds
    *       but does nothing else.
    *******************************************************************************************/
    public static float calculateOdds(int odds){
        //uses math to calculate the odds using the users chosen peramiters 
        float chances = 100; 
        for(int i = 0; i < odds; i++)   {
            chances = chances/2;
        }
        return chances;
    }

    /*******************************************************************************************
    *    neverTellMeTheOdds()
    * This function takes the calcualtion and prints it out
    *******************************************************************************************/
    public static void neverTellMeTheOdds(float odds){
        //tells user the odds nice and formally
        System.out.println("Odds of flipping a coin and landing on the same side: " + odds + "%");
    }
}
