/*******************************************************************************************
* Fibonacci
* By definition, the first two numbers in the Fibonacci sequence are 0 and 1,
* and each subsequent number is the sum of the previous two. This program
* will ask the user for how many numbers in the Fibonacci sequence to
* generate and print the numbers in a well-formatted way. Note that if
* you expect large numbers on the part of the user, an int data type may
* not suffice.
*
* 0, 1, 1, 2, 3, 5, 8, 13, 21, 34, 55, 89, 144.
* 0 + 1 == 1
* 1 + 1 == 2
* 1 + 2 == 3
* 2 + 3 == 5
* 3 + 5 == 8
*
* Author: Abigail Mott
* Date: 11/29/2023 - updated 10/9/2025
* Time Spent: 90 minutes
*******************************************************************************************/

import java.util.Scanner;

public class Fibonacci {
    static Scanner input = new Scanner(System.in);
    public static void main(String[] args) throws Exception {
        //introduce program
        System.out.println("This program will print out the requested amount of the Fibbonaci sequence");
        //call on the functions nessasary
        findFibonacci(userSequence());
    }
    /**************************************************************************
     * userSequence()
     * Takes in user input on how much of the sequence to print out
     **************************************************************************/
    public static long userSequence()   {
        //ask user how much of the sequence they want
        System.out.println("How much of the sequence do I need to print out?");
        //accept a long - just a longer int (can store more numbers)
        long sequenceNumber = input.nextInt();
        return sequenceNumber;
    }

    /**************************************************************************
     * findFibonacci()
     * prints out the fibonacci sequence to the point were user asked
     *************************************************************************/
    public static void findFibonacci(long sequenceNumber)  {
        //set up variables for the seequence
        long firstNumber = 0;
        long secondNumber = 1;
        //ouput the first and second to begin
        System.out.print(firstNumber + ", " + secondNumber);
        //start at 2, because we print out the first 2 numbers before for loop
        for(int i = 2; i < sequenceNumber; i++)   {
            //do some math to get the next number
            long followingNumber = firstNumber + secondNumber;
            //print out next number
            System.out.print(", " + followingNumber);
            //updating the variables so then the sequence continues
            firstNumber = secondNumber;
            secondNumber = followingNumber;
        }
    }
}
