
/*******************************************************************************************
* GregorianCalendar – Final Project
* This program will accept two integers from a user:
* A month 1-12, and
* A year after 1582.
* It will take these two numbers and print out a command line
* interface (CLI) calendar for that month.
*
* Learning Objectives: Use functions and print out a visually appealing calendar

* Author: Abigail Mott
* Date: 12/20/2023 - updated 10/9/2025
* Time Spent: roughly 2 weeks
*******************************************************************************************/
//import java.util.Scanner;
import java.util.Scanner;

public class GregorianCalendar {
    // colors
    public static final String RESET = "\u001B[0m"; // reset colors
    // for holidays
    public static final String RED = "\033[0;31m"; // RED

    static Scanner input = new Scanner(System.in);

    public static void main(String[] args) {
        //declare all nessasary variables which multiple functions will use
        boolean holiday = false;
        int Month = month();
        int Year = year();
        boolean leapYear = isLeapYear(Year);
        int dayOfWeek = getStartDay(Month, Year);
        int daysInMonth = getDaysInMonth(Month, Year, leapYear);
        checkHoliday(Month, holiday);
        printCalendar(Month, Year, leapYear, holiday, dayOfWeek, daysInMonth);
    }

    /*******************************************************************************************
     * month()
     * Gets the users selected month that they desire
     ******************************************************************************************/
    public static int month() {
        //ask user for which month of selected year they want
        System.out.print("Enter month (1-12): ");
        int month = input.nextInt();
        //catch any user input that is bad
        if (month < 1 || month > 12) {
            System.out.println("Please enter a month 1-12");
            return month();
        }
        return month;
    }

    /*******************************************************************************************
     * year()
     * Gets the users selected year that they desire
     ******************************************************************************************/
    public static int year() {
        //ask user for a specific year
        System.out.print("Enter year after 1582: ");
        int year = input.nextInt();
        //catch bad input from user
        if (year <= 1582) {
            System.out.println("Please enter a year after 1582");
            return year();
        }
        return year;
    }

    /*******************************************************************************************
     * getStartDay(int month, int day, int year)
     * gets the starting day of the week for the year.
     ******************************************************************************************/
    public static int getStartDay(int month, int year) {
        // Start with Saturday (6)
        int dayOfWeek = 6;

        // Add a day for each leap year since 1583 up to the year before the given year
        for (int i = 1583; i < year; i++) {
            if (isLeapYear(i)) {
                // if leap year adds one extra day
                dayOfWeek += 1; 
            }
        }
        System.out.println(dayOfWeek);
        // Add days for full years between 1583 and the year
        dayOfWeek += (year - 1583) * 365;
        System.out.println(dayOfWeek);
        // Add days for each month prior to the given month in the current year
        for (int i = 1; i < month; i++) {
            if (i == 1 || i == 3 || i == 5 || i == 7 || i == 8 || i == 10 || i == 12) {
                dayOfWeek += 31;
            } else if (i == 4 || i == 6 || i == 9 || i == 11) {
                dayOfWeek += 30;
            } else if (i == 2) {
                if (isLeapYear(year)) {
                    // February has 29 days in a leap year
                    dayOfWeek += 29;
                } else {
                    // February has 28 days in a non-leap year
                    dayOfWeek += 28; 
                }
            }
        }
        System.out.println(dayOfWeek);
        //mod the number so it's down to a number we can work with consistently
        dayOfWeek = dayOfWeek % 7;
        System.out.println(dayOfWeek);
        return dayOfWeek;
    }

    /*******************************************************************************************
     * isLeapYear(int year)
     * finds out if the users selected year is a leap year or not
     ******************************************************************************************/
    public static boolean isLeapYear(int year) {
        //complicated math (not really) that looks for if selected year is a leap year
        return  (year % 4 == 0 && (year % 100 != 0 || year % 400 == 0));
    }

    /*******************************************************************************************
     * checkHoliday()
     * finds out if there is a holiday in the month
     ******************************************************************************************/
    public static void checkHoliday(int month, boolean holiday) {
        //figure out holidays ... manually
        if (month == 1) {
            holiday = true;
            // New Year's Day - January 1st
            // Martin Luther King's Birthday - 3rd Monday in January
        }
        if (month == 2) {
            holiday = true;
            // Washington's Birthday - 3rd Monday in Febuary
        }
        if (month == 5) {
            holiday = true;
            // Memorial Day - Last Monday in May
        }
        if (month == 6) {
            holiday = true;
            // Juneteenth National Independence Day - June 19th
        }
        if (month == 7) {
            holiday = true;
            // Independence Day - July 4th
        }
        if (month == 9) {
            holiday = true;
            // Labor Day - 1st MOnday in September
        }
        if (month == 10) {
            holiday = true;
            // Veteran's Day - November 11
        }
        if (month == 11) {
            holiday = true;
            // Thanksgiving Day - 4th Thursday in November
        }
        if (month == 12) {
            holiday = true;
            // Christmas Day - December 25th
        }
    }

    /*******************************************************************************************
     * getDaysInMonth(int month, int year, boolean isLeapYear)
     * this function finds out whether the month has 29, 28, 31, or 30 days in it
     ******************************************************************************************/
    public static int getDaysInMonth(int month, int year, boolean isLeapYear) {
        //get the days in the month
        //febuary
        if (month == 2) {
            if (isLeapYear) {
                return 29;
            }
            return 28;
        }
        //normal months from here
        if (month <= 7 && month % 2 == 1) {
            return 31;
        }
        if (month >= 8 && month % 2 == 0) {
            return 31;
        }
        return 30;
    }

    /*******************************************************************************************
     * printCalendar(int month, int year, boolean, isLeapYear)
     * prints out the pretty little calandar with some loops and stuff.
     ******************************************************************************************/
    public static void printCalendar(int month, int year, boolean isLeapYear, boolean holiday, int dayOfWeek,
            int daysInMonth) {
        // print the start of the calander
        System.out.println(month + "/" + year);
        System.out.println(" Su  Mo  Tu  We  Th  Fr  Sa");
        //lots of variables made here, but used later
        int mondayCounter = 0;
        int thursdayCounter = 0;
        int dayWeek = dayOfWeek;
        boolean holidayWeek = false;
        int holiday1 = 0;
        int holiday2 = 0;
        // gets first day lined up
        for (int i = 0; i < dayOfWeek; i++) {
            System.out.print("    ");
        }
        // Print the days in line
        for (int day = 1; day <= daysInMonth; day++) {
            // Print the day with spaces to align the whole calander
            // so it doesn't look funky
            // I also found the %3d thingy searching online
            // it makes everything so pretty
            //does these counters for the holidays
            if (dayWeek == 1) {
                mondayCounter++;
            }
            if (dayWeek == 4) {
                thursdayCounter++;
            }
            if (month == 3 || month == 4 || month == 8) {
                System.out.printf("%3d ", day);
            }
            if (month == 1) {
                if (day == 1 || mondayCounter == 3 && dayWeek == 1) {
                    holidayWeek = true;
                    //use color to print out holidays
                    System.out.print(RED);
                    System.out.printf("%3d ", day);
                    System.out.print(RESET);
                    if (day == 1) {
                        holiday1 = 1;
                    }
                    if (mondayCounter == 3 && dayWeek == 1) {
                        holiday2 = 1;
                    }
                } else {
                    System.out.printf("%3d ", day);
                }
            }
            if (month == 2) {
                if (mondayCounter == 3 && dayWeek == 1) {
                    //more holiday coloring
                    holidayWeek = true;
                    System.out.print(RED);
                    System.out.printf("%3d ", day);
                    System.out.print(RESET);
                } else {
                    System.out.printf("%3d ", day);
                }
            }
            if (month == 5) {
                if (dayWeek == 1 && daysInMonth - day < 6) {
                    holidayWeek = true;
                    //another holiday
                    System.out.print(RED);
                    System.out.printf("%3d ", day);
                    System.out.print(RESET);
                }
                if (day == 31) {
                    System.out.printf("%3d ", day);
                    System.out.print(RED + "\tMemorial Day" + RESET);
                } else {
                    System.out.printf("%3d ", day);
                }
            }
            if (month == 6) {
                if (day == 19) {
                    holidayWeek = true;
                    //more holidays
                    System.out.print(RED);
                    System.out.printf("%3d ", day);
                    System.out.print(RESET);
                } else {
                    System.out.printf("%3d ", day);
                }
            }
            if (month == 7) {
                if (day == 4) {
                    holidayWeek = true;
                    //more holidays 
                    System.out.print(RED);
                    System.out.printf("%3d ", day);
                    System.out.print(RESET);
                } else {
                    System.out.printf("%3d ", day);
                }
            }
            if (month == 9) {
                if (dayWeek == 1 && mondayCounter == 1) {
                    //more holidays 
                    holidayWeek = true;
                    System.out.print(RED);
                    System.out.printf("%3d ", day);
                    System.out.print(RESET);
                } else {
                    System.out.printf("%3d ", day);
                }
            }
            if (month == 10) {
                if (dayWeek == 1 && mondayCounter == 2) {
                    //more holidays 
                    holidayWeek = true;
                    System.out.print(RED);
                    System.out.printf("%3d ", day);
                    System.out.print(RESET);
                } else {
                    System.out.printf("%3d ", day);
                }
            }
            if (month == 11) {
                if (day == 11 || dayWeek == 4 && thursdayCounter == 4) {
                    //more holidays 
                    holidayWeek = true;
                    System.out.print(RED);
                    System.out.printf("%3d ", day);
                    System.out.print(RESET);
                } else {
                    System.out.printf("%3d ", day);
                }
                if (day == 11) {
                    holiday1 = 1;
                }
                if (dayWeek == 4 && thursdayCounter == 4) {
                    holiday2 = 1;
                }
            }
            if (month == 12) {
                if (day == 25) {
                    //more holidays 
                    holidayWeek = true;
                    System.out.print(RED);
                    System.out.printf("%3d ", day);
                    System.out.print(RESET);
                } else {
                    System.out.printf("%3d ", day);
                }
            }
            // Move to the next line after Saturday
            if ((day + dayOfWeek) % 7 == 0) {
                //print out holidays for their months
                if (month == 1 && holidayWeek) {
                    if (holiday1 == 1) {
                        System.out.print(RED + "\tNew Year's Day" + RESET);
                        holiday1 = 0;
                    }
                    if (holiday2 == 1) {
                        System.out.print(RED + "\tMartin Luther King's Birthday" + RESET);
                        holiday2 = 0;
                    }
                    holidayWeek = false;
                }
                if (month == 2 && holidayWeek) {
                    System.out.print(RED + "\tWashingTon's Birthday" + RESET);
                    holidayWeek = false;
                }
                if (month == 6 && holidayWeek) {
                    System.out.print(RED + "\tJuneteenth National Independence Day" + RESET);
                    holidayWeek = false;
                }
                if (month == 7 && holidayWeek) {
                    System.out.print(RED + "\tIndependence Day" + RESET);
                    holidayWeek = false;
                }
                if (month == 9 && holidayWeek) {
                    System.out.print(RED + "\tLabor Day" + RESET);
                    holidayWeek = false;
                }
                if (month == 10 && holidayWeek) {
                    System.out.print(RED + "\tColumbus Day" + RESET);
                    holidayWeek = false;
                }
                if (month == 11 && holidayWeek) {
                    if (holiday1 == 1) {
                        System.out.print(RED + "\tVeteran's Day" + RESET);
                        holiday1 = 0;
                    }
                    if (holiday2 == 1) {
                        System.out.print(RED + "\tThanksgiving Day" + RESET);
                        holiday2 = 0;
                    }
                    holidayWeek = false;
                }
                if (month == 12 && holidayWeek) {
                    System.out.print(RED + "\tChristmas Day" + RESET);
                    holidayWeek = false;
                }
                System.out.println();
            }
            dayWeek++;
            if (dayWeek == 7) {
                dayWeek = 0;
            }
        }
    }
}
