import java.util.Scanner;
import java.util.ArrayList;
import java.util.List;

/*******************************************************************************************
 * Makeshapes
 * This project will pring out shapes
 *
 * Author: Abigail Mott
 * Date: 2/16/2024
 * Time Spent: lots
 *******************************************************************************************/

public class MakeShapes {
    static int userSelection = 0; // global and reusable user-selection variable
    static List<Circle> userCircles = new ArrayList<Circle>();
    static List<Rectangle> userRectangle = new ArrayList<Rectangle>();
    static List<Triangle> userTriangle = new ArrayList<Triangle>();
    public static Scanner input = new Scanner(System.in);

    /*******************************************************************************************
     * main()
     *******************************************************************************************/
    public static void main(String[] args) throws Exception {
        boolean loopOtherMenu = true;
        boolean loopMenu = true;
        System.out.println("Hello, Shapes");
        // declare attributes

        System.out.println("This program takes your inputs to create and display shapes");

        printMenu();

        // loop to allow the user to select from a list
        while (loopMenu) {

            int userSelection = input.nextInt();
            // if its not an option, it sends the user back again
            if (userSelection < 1 || userSelection > 3) {
                System.out.println("Choose between the options... please");
                printMenu();
            }
            // print shape menu selection
            if (userSelection == 1) {
                printCreateShapeMenu();
                userSelection = input.nextInt();
                if (userSelection == 1) {
                    // add one to userCircles
                    userCircles.add(new Circle());
                    userCircles.get(userCircles.size() - 1).display(); // print most recent shapes
                }
                if (userSelection == 2) {
                    // add one to userRectangle
                    userRectangle.add(new Rectangle());
                    userRectangle.get(userRectangle.size() - 1).display(); // print most recent shapes
                }
                if (userSelection == 3) {
                    // add one to userTriangle
                    userTriangle.add(new Triangle());
                    userTriangle.get(userTriangle.size() - 1).display(); // print most recent shapes
                }
                if (userSelection == 4) {
                    printMenu();
                    userSelection = 0;
                }
            }
            // past shape selection
            if (userSelection == 2) {
                printPastShapeMenu();
                int PastShapesSelection = input.nextInt();
                // prints all past circles selection
                if (PastShapesSelection == 1) {
                    int circleLength = userCircles.size();
                    System.out.println("\n");
                    for (int i = 0; i < circleLength;) {
                        System.out.print(i + 1);
                        i++;
                        if (circleLength != i) {
                            System.out.print(",");
                        }
                    }
                    // finds circle from circle array
                    System.out.println("\nEnter the specific number of the circle you want to print: ");
                    int circleIndex = input.nextInt() - 1;
                    if (circleIndex >= 0 && circleIndex < userCircles.size()) {
                        userCircles.get(circleIndex).display();
                    }
                    // if not a circle, then they sends them here
                    if (circleIndex < 0 || circleIndex > userCircles.size()) {
                        System.out.println("Thats not a circle, please try again.");
                        printPastShapeMenu();
                    }
                    System.out.println("Do you want to modify or see the specs of this circle? 1 Yes, 2 No");
                    userSelection = input.nextInt();
                    if (userSelection == 2) {
                        printMenu();
                    }
                    // if they want to modify circle, sends them here
                    if (userSelection == 1) {
                        while (loopOtherMenu) {
                            printCircleModifyMenu();
                            userSelection = 0;
                            userSelection = input.nextInt();
                            // change color
                            if (userSelection == 1) {
                                Shape.setColor();
                                userCircles.get(circleIndex).display();
                            }
                            // change width
                            if (userSelection == 2) {
                                Shape.setWidth();
                                userCircles.get(circleIndex).display();
                            }
                            // print area of circle
                            if (userSelection == 3) {
                                System.out.println("Circle area is: " + Math.PI * Math.pow(Circle.getRadius(), 2)
                                        + " cm squared");
                            }
                            // print perimeter of circle
                            if (userSelection == 4) {
                                System.out.println(
                                        "Circle perimeter is: " + 2 * Math.PI * Circle.getRadius() + " cm");
                            }
                            // returns to main menu
                            if (userSelection == 5) {
                                printMenu();
                            }
                            System.out.println(
                                    "Do you want to modify or see the specs of this circle still? 1 Yes, 2 No");
                            int userModifyCircle = input.nextInt();
                            if (userModifyCircle == 2) {
                                loopOtherMenu = false;
                            }
                        }
                    }

                }
                if (PastShapesSelection == 2) {
                    // prints past rectangle selection
                    int rectangleLength = userRectangle.size();
                    System.out.println("\n");
                    for (int i = 0; i < rectangleLength;) {
                        System.out.print(i + 1);
                        i++;
                        if (rectangleLength != i) {
                            System.out.print(",");
                        }
                    }
                    // gets specific rectangle
                    System.out.println("\nEnter the specific number of the rectangle you want to print: ");
                    int rectangleIndex = input.nextInt() - 1;
                    if (rectangleIndex >= 0 && rectangleIndex < userRectangle.size()) {
                        userRectangle.get(rectangleIndex).display();
                    }
                    // if users option isn't a rectangle, sends them back
                    if (rectangleIndex < 0 || rectangleIndex > userCircles.size()) {
                        System.out.println("Thats not a rectangle, please try again.");
                        printPastShapeMenu();
                    }
                    System.out.println("Do you want to modify or see the specs of this rectangle? 1 Yes, 2 No");
                    userSelection = input.nextInt();
                    if (userSelection == 2) {
                        printMenu();
                    }
                    // modify's the selected rectangle
                    if (userSelection == 1) {
                        printRectangleModifyMenu();
                        userSelection = 0;
                        userSelection = input.nextInt();
                        // color
                        if (userSelection == 1) {
                            Shape.setColor();
                            userRectangle.get(rectangleIndex).display();
                        }
                        // width
                        if (userSelection == 2) {
                            Shape.setWidth();
                            userRectangle.get(rectangleIndex).display();
                        }
                        // get area
                        if (userSelection == 3) {
                            System.out.println(
                                    "Rectangle area is: " + Rectangle.width * Rectangle.height + " cm squared");
                        }
                        // get perimeter
                        if (userSelection == 4) {
                            System.out.println("Rectangle perimeter is: " + (Rectangle.width * 2)
                                    + (Rectangle.height * 2) + " cm");
                        }
                        if (userSelection == 5) {
                            printMenu();
                        }
                    }
                }
                if (PastShapesSelection == 3) {
                    // triangle past selection
                    int triangleLength = userTriangle.size();
                    System.out.println("\n");
                    for (int i = 0; i < triangleLength;) {
                        System.out.print(i + 1);
                        i++;
                        if (triangleLength != i) {
                            System.out.print(",");
                        }
                    }
                    // prints specific triangle they want
                    System.out.println("\nEnter the specific number of the triangle you want to print: ");
                    int triangleIndex = input.nextInt() - 1;
                    if (triangleIndex >= 0 && triangleIndex < userTriangle.size()) {
                        userTriangle.get(triangleIndex).display();
                    }
                    // if user chooses a non triangle, sends user here
                    if (triangleIndex < 0 || triangleIndex > userCircles.size()) {
                        System.out.println("Thats not a triangle, please try again.");
                        printPastShapeMenu();
                    }
                    System.out.println("Do you want to modify or see the specs of this triangle? 1 Yes, 2 No");
                    userSelection = input.nextInt();
                    if (userSelection == 2) {
                        printMenu();
                    }
                    // modifiy menu
                    // ***************************************************** */
                    // triangle mod menu - implement after done w triangle
                    // ***************************************************** */
                    if (userSelection == 1) {
                        printTriangleModifyMenu();
                        userSelection = 0;
                        // not done with triangle, therefore not done with this
                    }
                }
                if (PastShapesSelection == 4) {
                    printMenu();
                }
            }
            if (userSelection == 3) {
                loopMenu = false;
            }
            userSelection = 0;

        }
    }

    /*******************************************************************************************
     * printMenu()
     * prints out the main menu
     *******************************************************************************************/
    public static void printMenu() {
        System.out.println("\n\t\tMAIN MENU"); // heading
        System.out.println("-----------------------------------------");
        System.out.println("1.\tPRINT SHAPE MENU"); // first Choice of printing the selected shape
        System.out.println("2.\tPAST SHAPE MENU"); // second choice of selecting a shape
        System.out.println("3. EXIT PROGRAM"); // third choice of exiting program
    }

    /*******************************************************************************************
     * printCreateShapeMenu()
     * prints out the shape
     *******************************************************************************************/
    public static void printCreateShapeMenu() {
        System.out.println("\nWhat shape do you want to print?");
        System.out.println("1. CIRCLE");
        System.out.println("2. RECTANGLE");
        System.out.println("3. TRIANGLE");
        System.out.println("4. MAIN MENU");
    }

    /*******************************************************************************************
     * printSelectShapeMenu()
     * prints out the menu where you select a past shape to print
     *******************************************************************************************/
    public static void printPastShapeMenu() {
        System.out.println("\n\t\tPAST SHAPES MENU");
        System.out.println("-----------------------------------------");
        System.out.println("1. View Past Circles");
        System.out.println("2. View Past Rectangles");
        System.out.println("3. View Past Triangles");
        System.out.println("4. Return to Main Menu");
    }

    /*******************************************************************************************
     * printCircleShapeMenu()
     * prints out the menu where you change a circle
     *******************************************************************************************/
    public static void printCircleModifyMenu() {
        System.out.println("\n\t\tMODIFY CIRCLES MENU");
        System.out.println("-----------------------------------------");
        System.out.println("1. CHANGE CIRCLE COLOR");
        System.out.println("2. CHANGE CIRCLE WIDTH");
        System.out.println("3. GET AREA OF CIRCLE");
        System.out.println("4. GET PERIMETER OF CIRCLE");
        System.out.println("5. RETURN MAIN MENU");
    }

    /*******************************************************************************************
     * printRectangleShapeMenu()
     * prints out the menu where you change a rectangle
     *******************************************************************************************/
    public static void printRectangleModifyMenu() {
        System.out.println("\n\t\tMODIFY RECTANGLE MENU");
        System.out.println("-----------------------------------------");
        System.out.println("1. Change the shape color");
        System.out.println("2. Change width of the shape");
        System.out.println("3. Get area of shape");
        System.out.println("4. Get perimeter of shape");
        System.out.println("4. Return to Main Menu");
    }

    /*******************************************************************************************
     * printTriangleShapeMenu()
     * prints out the menu where you change a triangle
     *******************************************************************************************/
    public static void printTriangleModifyMenu() {
        // NOT DONE WITH TRIANGLE, THEREFORE NOT DONE WITH THIS.
        System.out.println("\n\t\tMODIFY TRIANGLE MENU");
        System.out.println("-----------------------------------------");
        System.out.println("1. Change the shape color");
        System.out.println("2. Change width of the shape");
        System.out.println("3. Get area of shape");
        System.out.println("4. Get perimeter of shape");
        System.out.println("4. Return to Main Menu");
    }
}

