/*******************************************************************************************
 * Shapes
 *     This abstract class will support other shape classes
 *******************************************************************************************/

 abstract class Shape {
    // Define the following attributes
    // -area: double
    // -width: double
    // -height: double
    // -color: String
    // -sides: int
   protected static int userModifyCircle = 0;
   protected static int userModifyRectangle = 0;
   protected static int userModifyTriangle = 0;
   protected static double width = 0.0;
   protected static double height = 0.0;
   protected static int colorSelect = 9;
   protected int sides = 0;
   protected String[] PrettyAngles = {"A","B","C"};
   protected String[] PrettySides = {"a","b","c"};
   protected double[] mathSides = {0.0,0.0,0.0};
   protected double[] mathAngles = {0.0,0.0,0.0};
   protected double[] sins = {0.0,0.0,0.0};
   protected double[] cos = {0.0,0.0,0.0};
   protected double[] tan = {0.0,0.0,0.0};


   public static final String BLACK = "\033[0;30m"; // BLACK
   public static final String RED = "\033[0;31m"; // RED
   public static final String GREEN = "\033[0;32m"; // GREEN
   public static final String YELLOW = "\033[0;33m"; // YELLOW
   public static final String BLUE = "\033[0;34m"; // BLUE
   public static final String PURPLE = "\033[0;35m"; // PURPLE
   public static final String CYAN = "\033[0;36m"; // CYAN
   public static final String WHITE = "\033[0;37m"; // WHITE
    // RESET
   public static final String RESET = "\033[0m"; // TEXT RESET

    // DISAPEAR
   public static final String DISAPEAR = "\033[8;33m";

   // USERCOLOR
   public static final String USERCOLOR = "\033[0m"; // USERSCOLOR

   protected static String color = USERCOLOR; //color
 
   /*******************************************************************************************
   * # abstract getArea() : double
   *******************************************************************************************/
   protected abstract double getArea();

   /*******************************************************************************************
   * # abstract getPerimeter() : double
   *******************************************************************************************/
   protected abstract double getPerimeter();

   /*******************************************************************************************
   * + getWidth() : double
   *******************************************************************************************/
   public static double getWidth() {
      return width;
   }
   /*******************************************************************************************
   * + setWidth() : void
   *    set the width from the user input
   *******************************************************************************************/
   public static void setWidth() {
      //ask for width
      System.out.print("What do you want the width to be in cm? \n");
      // get width from user
      width = MakeShapes.input.nextInt();
      // change variable to userVariable
      System.out.println("\n Shape width is now: "+ width + " cm");
   }

   /*******************************************************************************************
   * + getHeight() : double
   *******************************************************************************************/
   public double getHeight() {
      return height;
   }
   /*******************************************************************************************
   * + setHeight() : void
   *     set the height from the user input
   *******************************************************************************************/
   public void setHeight() {
      //ask for height
      System.out.println("What do you want the height to be in cm?\n");
      // get height from user
      height = MakeShapes.input.nextInt();
      // change variable to userVariable
      System.out.print("\n Shape height is now: "+ height + " cm");
   }

    /*******************************************************************************************
    * + getColor() : String
    *******************************************************************************************/
    public String getColor() {
      return color;
    }

   /*******************************************************************************************
   * + setColor() : void
   * set the color from the user input
   *******************************************************************************************/
   public static void setColor() {
      //ask for color
      System.out.println("\nWhat color do you want your shape to be?");
      System.out.println("\t1. Black\n\t2. Red\n\t3. Green\n\t4. Yellow\n\t5. Blue\n\t6. Purple\n\t7. Cyan\n\t8. White\n\t9. Reset");
      // get color from user
      colorSelect = MakeShapes.input.nextInt();
      // change variable to userVariable
      if(colorSelect == 1) {
         color = BLACK;
         System.out.println("Color is now black");
      }
      if(colorSelect == 2) {
         color = RED;
         System.out.println("Color is now red");
      }
      if(colorSelect == 3) {
         color = GREEN;
         System.out.println("Color is now green");
      }
      if(colorSelect == 4) {
         color = YELLOW;
         System.out.println("Color is now yellow");
      }
      if(colorSelect == 5) {
         color = BLUE;
         System.out.println("Color is now blue");
      }
      if(colorSelect == 6) {
         color = PURPLE;
         System.out.println("Color is now purple");
      }
      if(colorSelect == 7) {
         color = CYAN;
         System.out.println("Color is now cyan");
      }
      if(colorSelect == 8) {
         color = WHITE;
         System.out.println("Color is now white");
      }
      if(colorSelect == 9) {
         color = RESET;
         System.out.println("Color is now reset");
      }
   }
   /*******************************************************************************************
   * + getSides() : int
   *******************************************************************************************/
   public int getSides() {
      return sides;
   }
   /*******************************************************************************************
   * # abstract display(): void
   *     should be overloaded in each class
   *******************************************************************************************/
   protected abstract void display();
   
}