import java.util.Scanner;
import java.lang.Math;

public class Triangle extends Shape {
    public static Scanner input = new Scanner(System.in);

    public Triangle() {
        acceptUsersKnownSOA();
    }

    /*******************************************************************************************
     * + userMap() : void
     *******************************************************************************************/
    public void userMap() {
        System.out.println("Type in all the info of triangle that you have");
        System.out.println("         " + PrettyAngles[2]);
        System.out.println("         *");
        System.out.println("        * *");
        System.out.println("       *   *      ");
        System.out.println("      *     *  ");
        if(!PrettySides[1].equals("b")) {
            mathSides[1] = Double.parseDouble(PrettySides[1]);
            if(mathSides[1] > 9)    {
                System.out.println(" " + PrettySides[1] + "  *       *   " + PrettySides[0]);
            }
        }
        if(!PrettySides[1].equals("b")) {
            mathSides[1] = Double.parseDouble(PrettySides[1]);
            if(mathSides[1] > 99)    {
                System.out.println(PrettySides[1] + "  *       *   " + PrettySides[0]);
            }
        }
        if(PrettySides[1].equals("b"))  {
            System.out.println("  " + PrettySides[1] + "  *       *   " + PrettySides[0]);
        }
        System.out.println("    *         *");
        System.out.println("   *           *");
        System.out.println("  * * * * * * * *");
        System.out.println(PrettyAngles[0] + "        " + PrettySides[2] + "        " + PrettyAngles[1]);
        System.out.println("\n Type the letter, in upper or lowercase, and the space, then the number");
        System.out.println("Will loop until you type (X)");
    }

    /*******************************************************************************************
     * + acceptUsersKnownSOA() : void
     *******************************************************************************************/
    public void acceptUsersKnownSOA() {
        boolean LoopDone = false;
        do {
            userMap();
            String usersInfo = input.nextLine();
            if (usersInfo.equalsIgnoreCase("X")) {
                LoopDone = true;
            }
            String[] parts = usersInfo.split(" ");
            if (parts.length >= 2) {
                char letter = parts[0].charAt(0);
                String number = parts[1];
                if (letter == 'A') {
                    PrettyAngles[0] = number;
                }
                if (letter == 'B') {

                    PrettyAngles[1] = number;
                }
                if (letter == 'C') {
                    PrettyAngles[2] = number;
                }
                if (letter == 'a') {
                    PrettySides[0] = number;
                }
                if (letter == 'b') {
                    PrettySides[1] = number;
                }
                if (letter == 'c') {
                    PrettySides[2] = number;
                }
            }
        } while (!LoopDone);
        calculateTypeOfTriangle();
    }

    /*******************************************************************************************
     * + calculateSins() : double
     *******************************************************************************************/
    public double[] calculateSins()  {
        if(!PrettyAngles[0].equals("A"))    {
            sins[0] = Math.cos(Math.toRadians(mathAngles[0]));
        }
        if(!PrettyAngles[1].equals("B"))    {
            sins[1] = Math.cos(Math.toRadians(mathAngles[1]));
        }
        if(!PrettyAngles[1].equals("B"))    {
            sins[2] = Math.cos(Math.toRadians(mathAngles[2])); 
        }
        return sins;
    }

    /*******************************************************************************************
     * + calculateSins() : double
     *******************************************************************************************/
    public double[] calculateCos() {
        if(!PrettyAngles[0].equals("A"))    {
            cos[0] = Math.cos(Math.toRadians(mathAngles[0]));
        }
        if(!PrettyAngles[1].equals("B"))    {
            cos[1] = Math.cos(Math.toRadians(mathAngles[1]));
        }
        if(!PrettyAngles[1].equals("B"))    {
            cos[2] = Math.cos(Math.toRadians(mathAngles[2])); 
        }
        return cos;
    }

    /*******************************************************************************************
     * + calculatetan() : double
     *******************************************************************************************/
    public double[] calculateTans() {
        if(!PrettyAngles[0].equals("A"))    {
            tan[0] = Math.cos(Math.toRadians(mathAngles[0]));
        }
        if(!PrettyAngles[1].equals("B"))    {
            tan[1] = Math.cos(Math.toRadians(mathAngles[1]));
        }
        if(!PrettyAngles[1].equals("B"))    {
            tan[2] = Math.cos(Math.toRadians(mathAngles[2])); 
        }
        return tan;
    }

    /*******************************************************************************************
     * + calculateTypeOfTriangle() : String
     *******************************************************************************************/
    public void calculateTypeOfTriangle() {
        String triangleType = "";

        // SSS -checks possible (one time)
        if (!PrettySides[0].equals("a") && !PrettySides[1].equals("b") && !PrettySides[2].equals("c")) {
            triangleType = "SSS";
            getSidesOfTriangle(triangleType, sins, cos, tan);
        }
        // SAS - checks all possible combos
        else if ((!PrettySides[0].equals("a") && !PrettySides[1].equals("b")) ||
                (!PrettySides[1].equals("b") && !PrettySides[2].equals("c")) ||
                (!PrettySides[0].equals("a") && !PrettySides[2].equals("c"))) {
            triangleType = "SAS";
            getSidesOfTriangle(triangleType, sins, cos, tan);
        }
        // SAA - checks for all possible combos
        // have to use else if, or wouldn't work at all - thanks gpt
        else if ((!PrettySides[0].equals("a") && !PrettyAngles[1].equals("A") && !PrettyAngles[0].equals("B")) ||
                (!PrettySides[0].equals("b") && !PrettyAngles[1].equals("A") && !PrettyAngles[0].equals("B")) ||
                (!PrettySides[0].equals("c") && !PrettyAngles[1].equals("A") && !PrettyAngles[0].equals("B")) ||
                (!PrettySides[0].equals("a") && !PrettyAngles[1].equals("A") && !PrettyAngles[0].equals("C")) ||
                (!PrettySides[0].equals("b") && !PrettyAngles[1].equals("A") && !PrettyAngles[0].equals("C")) ||
                (!PrettySides[0].equals("c") && !PrettyAngles[1].equals("A") && !PrettyAngles[0].equals("C")) ||
                (!PrettySides[0].equals("a") && !PrettyAngles[1].equals("B") && !PrettyAngles[0].equals("C")) ||
                (!PrettySides[0].equals("b") && !PrettyAngles[1].equals("B") && !PrettyAngles[0].equals("C")) ||
                (!PrettySides[0].equals("c") && !PrettyAngles[1].equals("B") && !PrettyAngles[0].equals("C"))) {
            triangleType = "SAA";
            getSidesOfTriangle(triangleType, sins, cos, tan);
        }
        System.out.println(RED + "Sorry, not enough information, please make sure your triangle has at least 3 things, SSS, SAS, or SSA." + RESET);
        acceptUsersKnownSOA();
    }

    /*******************************************************************************************
     * + getSides() : double
     *******************************************************************************************/
    public double[] getSidesOfTriangle(String triangleType, double[] sins, double[] cos, double[] tan) {
        if (triangleType.equals("SSS")) {
            for (int i = 0; i < PrettySides.length; i++) {
                try {
                    // Parse the string element into an integer and store it in the int array to do
                    mathSides[i] = Double.parseDouble(PrettySides[i]);
                } catch (Exception e) {
                    System.out.println(RED + "Hey, I can't use letters to do math..." + RESET);
                    acceptUsersKnownSOA();
                }
            }
        }
        if(triangleType.equals("SAS"))  {
            //abA
            if(!PrettySides[0].equals("a") && !PrettySides[1].equals("b") && PrettySides[2].equals("c") && !PrettyAngles[0].equals("A"))    {
                mathSides[0] =  Double.parseDouble(PrettySides[0]);
                mathSides[1] =  Double.parseDouble(PrettySides[1]);
                mathAngles[0] =  Double.parseDouble(PrettyAngles[0]);
                double sidec = Math.sqrt(mathSides[0] * mathSides[0] + mathSides[1] * mathSides[1] - 2 * mathSides[0] * mathSides[1] * Math.cos(mathAngles[0]));
                mathSides[2] = sidec;
            }
            //abB
            if(!PrettySides[0].equals("a") && !PrettySides[1].equals("b") && PrettySides[2].equals("c") && !PrettyAngles[1].equals("B"))    {
                mathSides[0] =  Double.parseDouble(PrettySides[0]);
                mathSides[1] =  Double.parseDouble(PrettySides[1]);
                mathAngles[1] =  Double.parseDouble(PrettyAngles[1]);
                double sidec = Math.sqrt(mathSides[0] * mathSides[0] + mathSides[1] * mathSides[1] - 2 * mathSides[0] * mathSides[1] * Math.cos(mathAngles[1]));
                mathSides[2] = sidec;
            }
            //abC
            if(!PrettySides[0].equals("a") && !PrettySides[1].equals("b") && PrettySides[2].equals("c") && !PrettyAngles[2].equals("C"))    {
                mathSides[0] =  Double.parseDouble(PrettySides[0]);
                mathSides[1] =  Double.parseDouble(PrettySides[1]);
                mathAngles[2] =  Double.parseDouble(PrettyAngles[2]);
                double sidec = Math.sqrt(mathSides[0] * mathSides[0] + mathSides[1] * mathSides[1] - 2 * mathSides[0] * mathSides[1] * Math.cos(mathAngles[2]));
                mathSides[2] = sidec;
            }
            //acA
            if(!PrettySides[0].equals("a") && PrettySides[1].equals("b") && !PrettySides[2].equals("c") && !PrettyAngles[0].equals("A"))    {
                mathSides[0] =  Double.parseDouble(PrettySides[0]);
                mathSides[2] =  Double.parseDouble(PrettySides[2]);
                mathAngles[0] =  Double.parseDouble(PrettyAngles[0]);
                double sideb = Math.sqrt(mathSides[0] * mathSides[0] + mathSides[2] * mathSides[2] - 2 * mathSides[0] * mathSides[2] * Math.cos(mathAngles[0]));
                mathSides[1] = sideb;
            }
            //acB
            if(!PrettySides[0].equals("a") && PrettySides[1].equals("b") && !PrettySides[2].equals("c") && !PrettyAngles[1].equals("B"))    {
                mathSides[0] =  Double.parseDouble(PrettySides[0]);
                mathSides[1] =  Double.parseDouble(PrettySides[2]);
                mathAngles[1] =  Double.parseDouble(PrettyAngles[1]);
                double sideb = Math.sqrt(mathSides[0] * mathSides[0] + mathSides[2] * mathSides[2] - 2 * mathSides[0] * mathSides[2] * Math.cos(mathAngles[1]));
                mathSides[1] = sideb;
            }
            //acC
            if(!PrettySides[0].equals("a") && PrettySides[1].equals("b") && !PrettySides[2].equals("c") && !PrettyAngles[2].equals("C"))    {
                mathSides[0] =  Double.parseDouble(PrettySides[0]);
                mathSides[1] =  Double.parseDouble(PrettySides[2]);
                mathAngles[2] =  Double.parseDouble(PrettyAngles[2]);
                double sideb = Math.sqrt(mathSides[0] * mathSides[0] + mathSides[2] * mathSides[2] - 2 * mathSides[0] * mathSides[2] * Math.cos(mathAngles[2]));
                mathSides[1] = sideb;
            }
            //bcA
            if(PrettySides[0].equals("a") && !PrettySides[1].equals("b") && !PrettySides[2].equals("c") && !PrettyAngles[0].equals("A"))    {
                mathSides[1] =  Double.parseDouble(PrettySides[1]);
                mathSides[2] =  Double.parseDouble(PrettySides[2]);
                mathAngles[0] =  Double.parseDouble(PrettyAngles[0]);
                double sidea = Math.sqrt(mathSides[1] * mathSides[1] + mathSides[2] * mathSides[2] - 2 * mathSides[1] * mathSides[2] * Math.cos(mathAngles[0]));
                mathSides[0] = sidea;
            }
            //bcB
            if(PrettySides[0].equals("a") && !PrettySides[1].equals("b") && !PrettySides[2].equals("c") && !PrettyAngles[1].equals("B"))    {
                mathSides[1] =  Double.parseDouble(PrettySides[1]);
                mathSides[2] =  Double.parseDouble(PrettySides[2]);
                mathAngles[1] =  Double.parseDouble(PrettyAngles[1]);
                double sidea = Math.sqrt(mathSides[1] * mathSides[1] + mathSides[2] * mathSides[2] - 2 * mathSides[1] * mathSides[2] * Math.cos(mathAngles[1]));
                mathSides[0] = sidea;
            }
            //bcC
            if(PrettySides[0].equals("a") && !PrettySides[1].equals("b") && !PrettySides[2].equals("c") && !PrettyAngles[2].equals("C"))    {
                mathSides[1] =  Double.parseDouble(PrettySides[1]);
                mathSides[2] =  Double.parseDouble(PrettySides[2]);
                mathAngles[2] =  Double.parseDouble(PrettyAngles[2]);
                double sidea = Math.sqrt(mathSides[1] * mathSides[1] + mathSides[2] * mathSides[2] - 2 * mathSides[1] * mathSides[2] * Math.cos(mathAngles[2]));
                mathSides[0] = sidea;
            }
        }
        if(triangleType.equals("SAA"))  {
            //ABa
            if(!PrettyAngles[0].equals("A") && !PrettyAngles[1].equals("B") && PrettyAngles[2].equals("C") && !PrettySides[0].equals("a")) {
                mathAngles[0] =  Double.parseDouble(PrettyAngles[0]);
                mathAngles[1] =  Double.parseDouble(PrettyAngles[1]);
                mathSides[0] =  Double.parseDouble(PrettySides[0]);
                mathSides[1] = (mathAngles[0] * sins[1]) / sins[0];
                mathSides[2] = (mathAngles[0] * Math.sin(Math.PI - mathAngles[0] - mathAngles[1])) / sins[0];
            }
            //ABb
            if(!PrettyAngles[0].equals("A") && !PrettyAngles[1].equals("B") && PrettyAngles[2].equals("C") && !PrettySides[1].equals("b")) {
                mathAngles[0] =  Double.parseDouble(PrettyAngles[0]);
                mathAngles[1] =  Double.parseDouble(PrettyAngles[1]);
                mathSides[1] =  Double.parseDouble(PrettySides[1]);
                mathSides[0] = (mathAngles[0] * sins[1]) / sins[0];
                mathSides[2] = (mathAngles[0] * Math.sin(Math.PI - mathAngles[0] - mathAngles[1])) / sins[0];
            }
            //ABc
            if(!PrettyAngles[0].equals("A") && !PrettyAngles[1].equals("B") && PrettyAngles[2].equals("C") && !PrettySides[2].equals("c")) {
                mathAngles[0] =  Double.parseDouble(PrettyAngles[0]);
                mathAngles[1] =  Double.parseDouble(PrettyAngles[1]);
                mathSides[2] =  Double.parseDouble(PrettySides[2]);
                mathSides[0] = (mathAngles[0] * sins[1]) / sins[0];
                mathSides[1] = (mathAngles[0] * Math.sin(Math.PI - mathAngles[0] - mathAngles[1])) / sins[0];
            }
            //ACa
            if(!PrettyAngles[0].equals("A") && !PrettyAngles[1].equals("C") && PrettyAngles[2].equals("B") && !PrettySides[0].equals("a")) {
                mathAngles[0] =  Double.parseDouble(PrettyAngles[0]);
                mathAngles[2] =  Double.parseDouble(PrettyAngles[2]);
                mathSides[0] =  Double.parseDouble(PrettySides[0]);
                mathSides[1] = (mathAngles[0] * sins[1]) / sins[0];
                mathSides[2] = (mathAngles[0] * Math.sin(Math.PI - mathAngles[0] - mathAngles[1])) / sins[0];
            }
            //ACb
            if(!PrettyAngles[0].equals("A") && !PrettyAngles[1].equals("C") && PrettyAngles[2].equals("B") && !PrettySides[1].equals("b")) {
                mathAngles[0] =  Double.parseDouble(PrettyAngles[0]);
                mathAngles[2] =  Double.parseDouble(PrettyAngles[2]);
                mathSides[1] =  Double.parseDouble(PrettySides[1]);
                mathSides[0] = (mathAngles[0] * sins[1]) / sins[0];
                mathSides[2] = (mathAngles[0] * Math.sin(Math.PI - mathAngles[0] - mathAngles[1])) / sins[0];
            }
        }
        // for(int k = 0;k < mathSides.length; k++) {
        // System.out.print(mathSides[k] + ",");
        //
        return mathSides;
    }

    /*******************************************************************************************
     * + setSides() : void
     *******************************************************************************************/
    public void setSides() {

    }

    /*******************************************************************************************
     * + getAngles() : double
     *******************************************************************************************/
    public double getAngles() {
        return 0.0;
    }

    /*******************************************************************************************
     * + setAngles() : void
     *******************************************************************************************/
    public void setAngle() {

    }

    /*******************************************************************************************
     * + getPerimeter(): {redefines getPerimeter} : double
     *******************************************************************************************/
    public double getPerimeter() {
        // // Formula A = Pi^r^2
        // return 2 * Math.PI * getRadius();
        return 0.0;
    }

    /*******************************************************************************************
     * + getArea() {redefines getPerimeter} : double
     *******************************************************************************************/
    public double getArea() {
        // // Formula A = Pi^r^2
        // return Math.PI * Math.pow(getRadius(), 2);
        return 0.0;
    }

    /*******************************************************************************************
     * + display()
     *******************************************************************************************/
    public void display() {

    }
}
