/*******************************************************************************************
* SimpleRecursion
* For recursion to work, a function must call itself with modified parameters
* that move toward a "base case" or end case condition, which will return
* without calling itself
*
* Please make a simple countdown timer using recursion. Helpful code may
* include:
if (n <= 0){
std::cout << Blastoff!;
return;
}
std::cout << n << endl;
countdown(n-1);
*
* Author: Abigail Mott
* Date: 2/20/2025
* Time Spent: 15 minutes
*******************************************************************************************/
#include <iostream>
//delay uses this
#include <chrono>
#include <thread>
using namespace std;
int userInput = 0;
int n = 0;
//make a loop for program
bool loop = true;

/*******************************************************************************************\
* tryCatch()
* validates the userInput so it will work correctly in program and not die
*******************************************************************************************/
void tryCatch() {
	bool validInput = true;
	do {
		cin >> userInput;
		if (cin.fail() || userInput <= 0) {
			validInput = false;
			cout << "Invalid input! Please give an integer. \n";
			cin.clear();
			cin.ignore(numeric_limits<streamsize>::max(), '\n');
		}
		else {
			validInput = true;
		}
	} while (!validInput);

}

/*******************************************************************************************\
* tryCatch()
* validates the userInput so it will work correctly in program and not die
*******************************************************************************************/
int countdownTime() {
	//ask user to give us int
	cout << "How long do you want the timer to run for?\n";
	//run through catcher just in case user gives bad input.
	tryCatch();
	return userInput;
}

/*******************************************************************************************\
* countdown()
* the function that actually counts down
*******************************************************************************************/
void countdown(int n) {
	if (n == 0) {
		//if times up, lets user know
		cout << "Times up Chat\n";
	}
	else if (n != 0) {
		//if not, it counts down
		cout << n << endl;
		//delay 1 second
		this_thread::sleep_for(chrono::seconds(1));
		countdown(n - 1);
	}
}

int main() {
	//introduce user to the program
	cout << "Hello user! Welcome to a program that will run a timer for as long as you want.\n";
	//start a loop
	do  {
		//main menu
		cout << "(1) Do a countdown\n(2) Exit program\n";
		//ask user for input and check it
		tryCatch();
		if (userInput == 1) {
			//ask user to give us countdown time
			n = countdownTime();
			//send user to funciton that will run rest of program
			countdown(n);
		}
		//end program if userInput is 2
		if (userInput == 2) {
			loop = false;
		}
		//get mad at user if it doesn't give 1 or 2
		if (userInput > 2) {
			cout << "please, please, please just gimme a 1 or 2\n";
		}
	} while (loop == true);
}