import java.util.Scanner;

/******************************************************************************
 * Tic-Tac-Toe
 * 
 * Make a functional 2 player tic-tac-toe game that has game win check
 * 
 * https://www.w3schools.blog/ansi-colors-java - COLORS
 * 
 * Author: Abigail Mott
 * Date: 1/23/24
 * Time Spent: 270 minutes
 *******************************************************************************/
public class TicTacToe {

    static Scanner input = new Scanner(System.in);

    public static final String ANSI_DISAPEAR = "\033[8;33m";

    public static final String ANSI_RESET = "\u001B[0m"; // reset colors

    public static void main(String[] args) throws Exception {
        int boardArray[][] = { { 0, 0, 0 }, { 0, 0, 0 }, { 0, 0, 0 } };
        boolean playerOneTurn = false;
        int i = 0;

        System.out.println("Player 1 = X," + "\n" + "Player 2 = O");
        // do while loop to run through program until somone has won
        printBoard(boardArray);

        do {
            i++;
            playerTurn(boardArray, playerOneTurn, i);
            printBoard(boardArray);
        } while (gameWon(boardArray) == false);
    }

    /******************************************************************************
     * PlayerTurn()
     * Takes in player one's input for where to put an X
     *******************************************************************************/
    public static void playerTurn(int[][] board, boolean playerOneTurn, int i) {
        if (i % 2 == 1) {
            System.out.println("PLAYER ONE");
            playerOneTurn = true;
        }
        if (i % 2 == 0) {
            System.out.println("PLAYER TWO");
            playerOneTurn = false;
        }

        System.out.println("What column (1) (2) (3)");
        int column = input.nextInt() - 1;
        // column
        if (column >= 4) {
            System.out.println("no no, only 1-3");
            playerTurn(board, playerOneTurn, i);
        }

        System.out.println("What row (1) (2) (3)");
        int row = input.nextInt() - 1;
        // row
        if (row >= 3) {
            System.out.println("no no, only 1-3");
            playerTurn(board, playerOneTurn, i);
        }

        if (board[row][column] == 2 || board[row][column] == 1) {
            System.out.println("no, no, thats cheating, try again");
            playerTurn(board, playerOneTurn, i);
        }
        if (board[row][column] == 0 && playerOneTurn == true) {
            board[row][column] = 1;
        }
        if (board[row][column] == 0 && playerOneTurn == false) {
            board[row][column] = 2;
        }
    }

    /******************************************************************************
     * printBoard()
     * prints the board out to the console for user to see
     *******************************************************************************/
    public static void printBoard(int[][] board) {
        int i = 0;
        int j = 0;
        System.out.print("   1   2   3 \n");
        for (i = 0; i <= 2; i++) {
            System.out.print(i + 1 + "  ");
            // prints numbers on side
            for (j = 0; j <= 2; j++) {
                if (board[i][j] == 0) {
                    if (j == 2 && i != 2) {
                        System.out.print(" " + ANSI_DISAPEAR + board[i][j] + ANSI_RESET);
                        System.out.println("");
                        System.out.print("  ---|---|---");
                    }
                    if (i == 2 && j == 2) {
                        System.out.print(" " + ANSI_DISAPEAR + board[i][j] + ANSI_RESET);
                        System.out.println("");
                    }
                    // colors are used to not show 0's

                    if (j != 2) {
                        System.out.print("  |" + ANSI_DISAPEAR + board[i][j] + ANSI_RESET + "");
                        System.out.print(ANSI_RESET);
                    }
                }
                if (board[i][j] == 1) {
                    if (j == 2 && i != 2) {
                        System.out.println("X");
                        System.out.print("  ---|---|---");
                    }
                    if (j == 2 && i == 2) {
                        System.out.println("X");
                    }
                    if (j != 2) {
                        System.out.print("X | ");
                    }
                    // 1 allows for X to show
                }
                if (board[i][j] == 2) {
                    if (j == 2 && i != 2) {
                        System.out.println("O");
                        System.out.print("  ---|---|---");
                    }
                    if (j == 2 && i == 2) {
                        System.out.println("O");
                    }
                    if (j != 2) {
                        System.out.print("O | ");
                    }

                    // 2 allows for O to show
                }
            }
            System.out.println();
        }
    }

    /******************************************************************************
     * gameWon()
     * Checks the board to see if a player has won the game
     *******************************************************************************/
    public static boolean gameWon(int[][] board) {
        // all legit just player 1
        // top left to right
        if (board[0][0] == 1 && board[1][0] == 1 && board[2][0] == 1) {
            System.out.println("Congrates player 1, you Win!");
            return true;
        }
        // middle left to right
        if (board[0][1] == 1 && board[1][1] == 1 && board[2][1] == 1) {
            System.out.println("Congrates player 1, you Win!");
            return true;
        }
        // bottom left to right
        if (board[0][2] == 1 && board[1][2] == 1 && board[2][2] == 1) {
            System.out.println("Congrates player 1, you Win!");
            return true;
        }
        // left top to bottom
        if (board[0][0] == 1 && board[0][1] == 1 && board[0][2] == 1) {
            System.out.println("Congrates player 1, you Win!");
            return true;
        }
        // middle top to bottom
        if (board[1][0] == 1 && board[1][1] == 1 && board[1][2] == 1) {
            System.out.println("Congrates player 1, you Win!");
            return true;
        }
        // right top to bottom
        if (board[2][0] == 1 && board[2][1] == 1 && board[2][2] == 1) {
            System.out.println("Congrates player 1, you Win!");
            return true;
        }
        // left to right diagonal
        if (board[0][0] == 1 && board[1][1] == 1 && board[2][2] == 1) {
            System.out.println("Congrates player 1, you Win!");
            return true;
        }
        // right to left diagonal
        if (board[2][0] == 1 && board[1][1] == 1 && board[0][2] == 1) {
            System.out.println("Congrates player 1, you Win!");
            return true;
        }

        // here is where player 2 starts

        // top left to right

        if (board[0][0] == 2 && board[1][0] == 2 && board[2][0] == 2) {
            System.out.println("Congrates player 2, you Win!");
            return true;
        }
        // middle left to right
        if (board[0][1] == 2 && board[1][1] == 2 && board[2][1] == 2) {
            System.out.println("Congrates player 2, you Win!");
            return true;
        }
        // bottom left to right
        if (board[0][2] == 2 && board[1][2] == 2 && board[2][2] == 2) {
            System.out.println("Congrates player 2, you Win!");
            return true;
        }
        // left top to bottom
        if (board[0][0] == 2 && board[0][1] == 2 && board[0][2] == 2) {
            System.out.println("Congrates player 2, you Win!");
            return true;
        }
        // middle top to bottom
        if (board[1][0] == 2 && board[1][1] == 2 && board[1][2] == 2) {
            System.out.println("Congrates player 2, you Win!");
            return true;
        }
        // right top to bottom
        if (board[2][0] == 2 && board[2][1] == 2 && board[2][2] == 2) {
            System.out.println("Congrates player 2, you Win!");
            return true;
        }
        // left to right diagonal
        if (board[0][0] == 2 && board[1][1] == 2 && board[2][2] == 2) {
            System.out.println("Congrates player 2, you Win!");
            return true;
        }
        // right to left diagonal
        if (board[2][0] == 2 && board[1][1] == 2 && board[0][2] == 2) {
            System.out.println("Congrates player 2, you Win!");
            return true;
        }
        // check if draw
        if (board[0][0] != 0 && board[0][1] != 0 && board[0][2] != 0 && board[1][0] != 0 && board[1][1] != 0
                && board[1][2] != 0 && board[2][0] != 0 && board[2][1] != 0 && board[2][2] != 0) {
            System.out.println("Ya'll suck, Draw");
            return true;
        }
        return false;
    }
}
