/*******************************************************************************************
 * Games
 * This program will allow the user to play 2 games. Wordle and Jato.
 *
 * Author: Abigail Mott
 * Date: 1/25/24 - updated 10/9/2025
 * Time Spent: Around 2 weeks
 *******************************************************************************************/

//import java.util.Scanner;
//import java.util.Random;
import java.util.Scanner;
import java.util.Random;

public class Games {
    static Scanner input = new Scanner(System.in);
    public static Random random = new Random();

    // RESET
    public static final String RESET = "\033[0m"; // Text Reset

    // DISAPEAR
    public static final String DISAPEAR = "\033[8;33m";

    // REGULAR COLORS
    public static final String BLACK = "\033[0;30m"; // BLACK
    public static final String RED = "\033[0;31m"; // RED
    public static final String GREEN = "\033[0;32m"; // GREEN
    public static final String YELLOW = "\033[0;33m"; // YELLOW
    public static final String BLUE = "\033[0;34m"; // BLUE
    public static final String PURPLE = "\033[0;35m"; // PURPLE
    public static final String CYAN = "\033[0;36m"; // CYAN
    public static final String WHITE = "\033[0;37m"; // WHITE

    public static String[] userGuesses = { "", "", "", "", "", "" };
    public static int numWords = 3169;
    public static int five = 5;

    public static void main(String[] args) throws Exception {
        System.out.println("\nDo you want to play Wordle (1) or Jato (2)?");
        int userChoice = input.nextInt();
        if (userChoice == 1) {
            //send user to wordle
            Wordle();
        }
        if (userChoice == 2) {
            //send user to jato
            Jato();
        }
        //check if they hit 1 or 2, if not get mad
        if (userChoice != 1 || userChoice != 2) {
            System.out.println("What are you doing? Now we can't play either :(");
        }
    }

    /*******************************************************************************************
     * + Wordle(): void
     *******************************************************************************************/
    public static void Wordle() {
        // rules to the game
        System.out.println("Welcome to wordle.  Guess a 5 letter word and try to get the word right!");
        System.out.println(RED + "RULES:" + RESET + "\nWhite colored letter means that letter isn't in the word");
        System.out.println(
                YELLOW + "Yellow colored letter means there is that letter in the word, just wrongly placed." + RESET);
        System.out.println(GREEN + "Green colored word means correct letter and place." + RESET);

        // looping vairables
        boolean loopDone = false;
        boolean check = false;
        boolean gameWon = false;

        // gets a random word from word bank
        String solutionWord = Words.randomWord(random.nextInt(numWords));

        // counts num of turns
        int counter = 0;
        // counts users guesses

        int guesses = 1;

        // where to store guesses
        String guess1 = "";
        String guess2 = "";
        String guess3 = "";
        String guess4 = "";

        // users guesses
        String[] guessChecked = { "", "", "", "", "" };
        int[] guessColors = { 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, };

        // loop until user guesses it
        while (loopDone == false) {
            // has user take a guess
            System.out.println("\nWhat's you're guess? Guess counter: " + guesses);
            // catch the number, so then the actual guess doesn't freak out
            if (guesses == 1) {
                String collect = input.nextLine();
                System.out.print(DISAPEAR + collect + RESET);
            }
            String userGuess = input.nextLine();

            if(userGuess.length() != 5) {
                System.out.println("Buddy.  Try again.");
                guesses--;
            } else { // user guess has 5 letters

                userGuesses[counter] = userGuess;
                // for loop checks if the guess exists in word bank
                for (int i = 0; i < numWords; i++) {
                    if (i == 3168 && !userGuess.equals(Words.wordBank[i]) && check == false) {
                        System.out.println(RED + "THATS NOT A REAL WORD!" + RESET);
                        if (guesses == 1) {
                            guess1 = "";
                            guesses--;
                        }
                        if (guesses == 2) {
                            guess2 = "";
                            guesses--;
                        }
                        if (guesses == 3) {
                            guess3 = "";
                            guesses--;
                        }
                        if (guesses == 4) {
                            guess4 = "";
                            guesses--;
                        }
                    }
                    else    {
                        
                    }
                    if (userGuess.equals(Words.wordBank[i])) {
                        check = true;

                        // change colors to green
                        for (int j = 0; j < five; j++) {
                            if (userGuess.charAt(j) == solutionWord.charAt(j)) {
                                guessChecked[j] = GREEN + userGuess.charAt(j) + RESET;
                                // saves colors
                                if (guesses == 1) {
                                    guessColors[j] = 2;
                                }
                                if (guesses == 2) {
                                    guessColors[j + 5] = 2;
                                }
                                if (guesses == 3) {
                                    guessColors[j + 10] = 2;
                                }
                                if (guesses == 4) {
                                    guessColors[j + 15] = 2;
                                }

                            } else if (userGuess.charAt(j) == solutionWord.charAt(0) // change colors to yellow
                                    || userGuess.charAt(j) == solutionWord.charAt(1)
                                    || userGuess.charAt(j) == solutionWord.charAt(2)
                                    || userGuess.charAt(j) == solutionWord.charAt(3)
                                    || userGuess.charAt(j) == solutionWord.charAt(4)) {
                                guessChecked[j] = YELLOW + userGuess.charAt(j) + RESET;
                                // get colors saved
                                if (guesses == 1) {
                                    guessColors[j] = 1;
                                }
                                if (guesses == 2) {
                                    guessColors[j + 5] = 1;
                                }
                                if (guesses == 3) {
                                    guessColors[j + 10] = 1;
                                }
                                if (guesses == 4) {
                                    guessColors[j + 15] = 1;
                                }
                            } else { // leave white
                                guessChecked[j] = userGuess.charAt(j) + RESET;
                            }
                        }
                        // checks if user got the word right
                        if (userGuess.equals(solutionWord)) {
                            System.out.println(GREEN + "\nCongrats! you got it." + RESET);
                            loopDone = true;
                            gameWon = true;
                        }
                        // kicks user out if all 5 guesses have been made
                        if (guesses == five) {
                            System.out.println("Buddy, nice try.  The word was " + solutionWord);
                            loopDone = true;
                        }
                    }
                    // checks if the users guess is a real word, if not, makes them try again
                }
            }
            System.out.println("\tWORDLE");
            System.out.println("======================");
            // prints out first guess with colors

            if (guesses > 0) {
                if (guesses == 1) {
                    guess1 = userGuess;
                }
                for (int i = 0; i < 5; i++) {
                    if (i == 0) {
                        System.out.print("\t1. ");
                    }
                    if (guessColors[i] == 2) {
                        System.out.print(GREEN + guess1.charAt(i) + RESET);
                    }
                    if (guessColors[i] == 1) {
                        System.out.print(YELLOW + guess1.charAt(i) + RESET);
                    }
                    if (guessColors[i] == 0) {
                        System.out.print(guess1.charAt(i) + RESET);
                    }
                }
            }
            // prints out second guess with colors
            if (guesses > 1) {
                if (guesses == 2) {
                    guess2 = userGuess;
                }
                for (int i = 0; i < 5; i++) {
                    if (i == 0) {
                        System.out.print("\n\t2. ");
                    }
                    if (guessColors[i + 5] == 2) {
                        System.out.print(GREEN + guess2.charAt(i) + RESET);
                    }
                    if (guessColors[i + 5] == 1) {
                        System.out.print(YELLOW + guess2.charAt(i) + RESET);
                    }
                    if (guessColors[i + 5] == 0) {
                        System.out.print(guess2.charAt(i) + RESET);
                    }
                }
            }
            // prints out third guess with colors
            if (guesses > 2) {
                if (guesses == 3) {
                    guess3 = userGuess;
                }
                for (int i = 0; i < 5; i++) {
                    if (i == 0) {
                        System.out.print("\n\t3. ");
                    }
                    if (guessColors[i + 10] == 2) {
                        System.out.print(GREEN + guess3.charAt(i) + RESET);
                    }
                    if (guessColors[i + 10] == 1) {
                        System.out.print(YELLOW + guess3.charAt(i) + RESET);
                    }
                    if (guessColors[i + 10] == 0) {
                        System.out.print(guess3.charAt(i) + RESET);
                    }
                }
            }
            // prints out fourth guess with colors
            if (guesses > 3) {
                if (guesses == 4) {
                    guess4 = userGuess;
                }
                for (int i = 0; i < 5; i++) {
                    if (i == 0) {
                        System.out.print("\n\t4. ");
                    }
                    if (guessColors[i + 15] == 2) {
                        System.out.print(GREEN + guess4.charAt(i) + RESET);
                    }
                    if (guessColors[i + 15] == 1) {
                        System.out.print(YELLOW + guess4.charAt(i) + RESET);
                    }
                    if (guessColors[i + 15] == 0) {
                        System.out.print(guess4.charAt(i) + RESET);
                    }
                }
            }
            if(guesses == 5 && !gameWon)    {
                System.out.print("\n\t   " + RED + solutionWord + RESET);
            }
            if (loopDone == true && gameWon) {
                System.out.print("\n\t   " + GREEN + userGuess + RESET);
            }
            // adds 1 to counters and guesses to keep loop running
            check = false;
            counter++;
            guesses++;
        }
    }

    /*******************************************************************************************
     * + Jato): void
     *******************************************************************************************/
    public static void Jato() {
        System.out.println("Welcome to Jato!");
        System.out.println(RED + "RULES:" + RESET);
        System.out.println("Jato is a word game, where the player must take multiple guesses to" +
                "attempt and guess a random word");
        System.out.println("Once the guess has been made, it will tell the user how many letters of" +
                " the guess, are in the actual word.");
                System.out.println("This Jato also has the possiblity of their being multiple of the same letter in the word to guess");

        // variables
        int guessesNumber = 1;
        int lettersCorrect = 0;
        //collecting all the guesses
        String userGuesses[] = { "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
                "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
                "", "", "", "",
                "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
                "", "", "", "",
                "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "", "",
                "", "", "", "", };
                //collecting the guesses # of correct letters
        int userLettersCorrect[] = { 100000, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
                0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0 };
        // looping vairables
        boolean loopDone = false;
        boolean check = false;

        // gets a random word from word bank
        String solutionWord = Words.randomWord(random.nextInt(numWords));
        while (!loopDone) {
            // has user take a guess
            System.out.println("\nWhat's you're guess? Guess counter: " + guessesNumber);
            // catch the number, so then the actual guess doesn't freak out
            if (guessesNumber == 1) {
                String collect = input.nextLine();
                System.out.print(DISAPEAR + collect + RESET);
            }
            String userGuess = input.nextLine();
            //if user types in a guess less or more than 5 letters long, it stops them
            if (userGuess.length() != 5) {
                System.out.println("Buddy.  Try again.");
            } else {
                // for loop checks if the guess exists in word bank
                for (int i = 0; i < numWords; i++) {
                    if (userGuess.equals(Words.wordBank[i])) {
                        userGuesses[guessesNumber - 1] = userGuess;
                        System.out.println(userGuesses[guessesNumber]);
                        // change colors to green
                        for (int j = 0; j < five; j++) {
                            check = true;
                            if (userGuess.charAt(j) == solutionWord.charAt(0)
                                    || userGuess.charAt(j) == solutionWord.charAt(1)
                                    || userGuess.charAt(j) == solutionWord.charAt(2)
                                    || userGuess.charAt(j) == solutionWord.charAt(3)
                                    || userGuess.charAt(j) == solutionWord.charAt(4)) {
                                lettersCorrect++;
                            }
                        }
                        //transfers the letters correct into an array to store them
                        userLettersCorrect[guessesNumber - 1] = lettersCorrect;
                        // checks if user got the word right
                        if (userGuess.equals(solutionWord)) {
                            System.out.println(GREEN + "\nCongrats! you got it." + RESET);
                            loopDone = true;
                        }
                        // checks if the users guess is a real word, if not, makes them try again
                        if (i == 3168 && !userGuess.equals(Words.wordBank[i]) && check == false) {
                            System.out.println(RED + "THATS NOT A REAL WORD!" + RESET);
                        }
                    }
                }
            }
            // prints out all guesses and their corresponding # of correct letters
            System.out.println("\n\tJato - Guesses");
            System.out.print("==============================");
            for (int i = 1; i < guessesNumber + 1; i++) {
                System.out.print("\n\t" + (i) + ". " + userGuesses[i - 1] + " - Letters Correct = " + userLettersCorrect[i - 1]);
            }
            // creates more spacing before next guess
            System.out.println();
            guessesNumber++;
            lettersCorrect = 0;
        }
    }
}